
##Load libraries and data

library(readr)
library(effsize)
library(expss)

sui2 <- read_csv("suicide2.csv")


##Remove incomplete responses and people excluded due to prior suicide exposure

sui2 <- subset(sui2, random != "NA")
sui2 <- subset(sui2, random > 100000)


##Demographics

#Sex: 1 = male, 2 = female
count_if(1, sui2$Q14)
count_if(2, sui2$Q14)

#Age
mean(sui2$Q12)
sd(sui2$Q12)


##Descriptive statistics for each condition
mean(sui2$Ex, na.rm = TRUE)
sd(sui2$Ex, na.rm = TRUE)

mean(sui2$C, na.rm = TRUE)
sd(sui2$C, na.rm = TRUE)


##Create DV across conditions
sui2$dv <- rowMeans(data.frame(sui2$C, sui2$Ex), na.rm = TRUE)


##t-test comparing condition means
t.test(sui2$dv ~ sui2$Condition, var.equal = TRUE)
cohen.d(sui2$dv ~ sui2$Condition)


##t-tests comparing each condition mean to scale midpoint

#Experimental condition
t.test(sui2$Ex, mu = 8, na.rm = TRUE)

#Control condition
t.test(sui2$C, mu = 8, na.rm = TRUE)

