####Normative Opposition to Suicide####

###Study 1 Analysis Scripts###
###Authors: Justin F. Landy & Pritika Shah###


##Setting up

#Load packages
library(readr)
library(hablar)
library(lsr)
library(tidyr)
library(expss)


##Load and prepare data

#Load online data
data.suicide <- read_csv("suicide1.csv")

#Remove unnecessary columns
data.suicide <- data.suicide[, -c(1:16)]

#Retype to numeric
data.suicide <- retype(data.suicide)


##Demographics

#Sex
count_if(1, data.suicide$Sex)
count_if(2, data.suicide$Sex)

#Age
data.suicide$age <- 2020 - data.suicide$YearBorn
mean(data.suicide$age, na.rm = TRUE)
sd(data.suicide$age, na.rm = TRUE)


##Create subsamples for each comparison

#Time Left
data.suicide.timeleft <- data.suicide %>% drop_na(c("Std_Ctrl", "TimeLeft_Exp", "TimeLeft_Ctrl_MC", "TimeLeft_Exp_MC"))
data.suicide.socharm <- data.suicide %>% drop_na(c("Std_Ctrl", "SocHarm_Exp", "SocHarm_Ctrl_MC", "SocHarm_Exp_MC"))
data.suicide.soultaint <- data.suicide %>% drop_na(c("Std_Ctrl", "SoulTaint_Exp", "SoulTaint_Ctrl_MC", "SoulTaint_Exp_MC"))
data.suicide.selfharm <- data.suicide %>% drop_na(c("SelfHarm_Ctrl", "Std_Ctrl", "SelfHarm_Ctrl_MC", "SelfHarm_Exp_MC"))
data.suicide.severity <- data.suicide %>% drop_na(c("Severity_Ctrl", "Severity_Exp", "Severity_Ctrl_MC", "Severity_Exp_MC"))
data.suicide.euthanasia <- data.suicide %>% drop_na(c("Euth_Ctrl", "Euth_Exp", "Euth_Ctrl_MC", "Euth_Exp_MC"))
data.suicide.exposure <- data.suicide %>% drop_na(c("Std_Ctrl", "Exposure_Exp", "Exposure_Ctrl_MC", "Exposure_Exp_MC"))
data.suicide.attempt <- data.suicide %>% drop_na(c("Std_Ctrl", "Attempt_Exp", "Attempt_Ctrl_MC", "Attempt_Exp_MC"))
data.suicide.impulse <- data.suicide %>% drop_na(c("Impulse_Ctrl", "Impulse_Exp", "Impulse_Ctrl_MC", "Impulse_Exp_MC"))
data.suicide.relig <- data.suicide %>% drop_na(c("Relig_Ctrl", "Relig_Exp", "Relig_Ctrl_MC", "Relig_Exp_MC"))


##Manipulation Checks

#Time Left
mean(data.suicide.timeleft$TimeLeft_Ctrl_MC, na.rm = TRUE)
sd(data.suicide.timeleft$TimeLeft_Ctrl_MC, na.rm = TRUE)

mean(data.suicide.timeleft$TimeLeft_Exp_MC, na.rm = TRUE)
sd(data.suicide.timeleft$TimeLeft_Exp_MC, na.rm = TRUE)

t.test(data.suicide.timeleft$TimeLeft_Ctrl_MC, data.suicide.timeleft$TimeLeft_Exp_MC, paired = TRUE)
cohensD(data.suicide.timeleft$TimeLeft_Ctrl_MC, data.suicide.timeleft$TimeLeft_Exp_MC, method = "paired")

#Social Harm
mean(data.suicide.socharm$SocHarm_Ctrl_MC, na.rm = TRUE)
sd(data.suicide.socharm$SocHarm_Ctrl_MC, na.rm = TRUE)

mean(data.suicide.socharm$SocHarm_Exp_MC, na.rm = TRUE)
sd(data.suicide.socharm$SocHarm_Exp_MC, na.rm = TRUE)

t.test(data.suicide.socharm$SocHarm_Ctrl_MC, data.suicide.socharm$SocHarm_Exp_MC, paired = TRUE)
cohensD(data.suicide.socharm$SocHarm_Ctrl_MC, data.suicide.socharm$SocHarm_Exp_MC, method = "paired")

#Soul Taint
mean(data.suicide.soultaint$SoulTaint_Ctrl_MC, na.rm = TRUE)
sd(data.suicide.soultaint$SoulTaint_Ctrl_MC, na.rm = TRUE)

mean(data.suicide.soultaint$SoulTaint_Exp_MC, na.rm = TRUE)
sd(data.suicide.soultaint$SoulTaint_Exp_MC, na.rm = TRUE)

t.test(data.suicide.soultaint$SoulTaint_Ctrl_MC, data.suicide.soultaint$SoulTaint_Exp_MC, paired = TRUE)
cohensD(data.suicide.soultaint$SoulTaint_Ctrl_MC, data.suicide.soultaint$SoulTaint_Exp_MC, method = "paired")

#Self-Harm
mean(data.suicide.selfharm$SelfHarm_Ctrl_MC, na.rm = TRUE)
sd(data.suicide.selfharm$SelfHarm_Ctrl_MC, na.rm = TRUE)

mean(data.suicide.selfharm$SelfHarm_Exp_MC, na.rm = TRUE)
sd(data.suicide.selfharm$SelfHarm_Exp_MC, na.rm = TRUE)

t.test(data.suicide.selfharm$SelfHarm_Ctrl_MC, data.suicide.selfharm$SelfHarm_Exp_MC, paired = TRUE)
cohensD(data.suicide.selfharm$SelfHarm_Ctrl_MC, data.suicide.selfharm$SelfHarm_Exp_MC, method = "paired")

#Severity of Circumstances
mean(data.suicide.severity$Severity_Ctrl_MC, na.rm = TRUE)
sd(data.suicide.severity$Severity_Ctrl_MC, na.rm = TRUE)

mean(data.suicide.severity$Severity_Exp_MC, na.rm = TRUE)
sd(data.suicide.severity$Severity_Exp_MC, na.rm = TRUE)

t.test(data.suicide.severity$Severity_Ctrl_MC, data.suicide.severity$Severity_Exp_MC, paired = TRUE)
cohensD(data.suicide.severity$Severity_Ctrl_MC, data.suicide.severity$Severity_Exp_MC, method = "paired")

#Euthanasia
mean(data.suicide.euthanasia$Euth_Ctrl_MC, na.rm = TRUE)
sd(data.suicide.euthanasia$Euth_Ctrl_MC, na.rm = TRUE)

mean(data.suicide.euthanasia$Euth_Exp_MC, na.rm = TRUE)
sd(data.suicide.euthanasia$Euth_Exp_MC, na.rm = TRUE)

t.test(data.suicide.euthanasia$Euth_Ctrl_MC, data.suicide.euthanasia$Euth_Exp_MC, paired = TRUE)
cohensD(data.suicide.euthanasia$Euth_Ctrl_MC, data.suicide.euthanasia$Euth_Exp_MC, method = "paired")

#Exposure
mean(data.suicide.exposure$Exposure_Ctrl_MC, na.rm = TRUE)
sd(data.suicide.exposure$Exposure_Ctrl_MC, na.rm = TRUE)

mean(data.suicide.exposure$Exposure_Exp_MC, na.rm = TRUE)
sd(data.suicide.exposure$Exposure_Exp_MC, na.rm = TRUE)

t.test(data.suicide.exposure$Exposure_Ctrl_MC, data.suicide.exposure$Exposure_Exp_MC, paired = TRUE)
cohensD(data.suicide.exposure$Exposure_Ctrl_MC, data.suicide.exposure$Exposure_Exp_MC, method = "paired")

#Attempt
sum(data.suicide.attempt$Attempt_Ctrl_MC == 1, na.rm = TRUE)
sum(data.suicide.attempt$Attempt_Ctrl_MC == 2, na.rm = TRUE)

sum(data.suicide.attempt$Attempt_Exp_MC == 1, na.rm = TRUE)
sum(data.suicide.attempt$Attempt_Exp_MC == 2, na.rm = TRUE)

succ_succ <- sum(data.suicide.attempt$Attempt_Ctrl_MC == 1 & data.suicide.attempt$Attempt_Exp_MC == 1, na.rm = TRUE)
succ_fail <- sum(data.suicide.attempt$Attempt_Ctrl_MC == 1 & data.suicide.attempt$Attempt_Exp_MC == 2, na.rm = TRUE)
fail_succ <- sum(data.suicide.attempt$Attempt_Ctrl_MC == 2 & data.suicide.attempt$Attempt_Exp_MC == 1, na.rm = TRUE)
fail_fail <- sum(data.suicide.attempt$Attempt_Ctrl_MC == 2 & data.suicide.attempt$Attempt_Exp_MC == 2, na.rm = TRUE)

attempt_mc <- c(succ_succ, succ_fail, fail_succ, fail_fail)
attempt_mc <- matrix(attempt_mc, nrow = 2)
colnames(attempt_mc) <- c("ctrl.succ", "ctrl.fail")
rownames(attempt_mc) <- c("exp.succ", "exp.fail")

attempt_mc

mcnemar.test(attempt_mc)

remove(attempt_mc, succ_fail, succ_succ, fail_fail, fail_succ)

#Impulsive/Deliberate
mean(data.suicide.impulse$Impulse_Ctrl_MC, na.rm = TRUE)
sd(data.suicide.impulse$Impulse_Ctrl_MC, na.rm = TRUE)

mean(data.suicide.impulse$Impulse_Exp_MC, na.rm = TRUE)
sd(data.suicide.impulse$Impulse_Exp_MC, na.rm = TRUE)

t.test(data.suicide.impulse$Impulse_Ctrl_MC, data.suicide.impulse$Impulse_Exp_MC, paired = TRUE)
cohensD(data.suicide.impulse$Impulse_Ctrl_MC, data.suicide.impulse$Impulse_Exp_MC, method = "paired")

#Religious Background
mean(data.suicide.relig$Relig_Ctrl_MC, na.rm = TRUE)
sd(data.suicide.relig$Relig_Ctrl_MC, na.rm = TRUE)

mean(data.suicide.relig$Relig_Exp_MC, na.rm = TRUE)
sd(data.suicide.relig$Relig_Exp_MC, na.rm = TRUE)

t.test(data.suicide.relig$Relig_Ctrl_MC, data.suicide.relig$Relig_Exp_MC, paired = TRUE)
cohensD(data.suicide.relig$Relig_Ctrl_MC, data.suicide.relig$Relig_Exp_MC, method = "paired")


##Rightness/Wrongness Ratings

#Time Left
mean(data.suicide.timeleft$Std_Ctrl, na.rm = TRUE)
sd(data.suicide.timeleft$Std_Ctrl, na.rm = TRUE)

mean(data.suicide.timeleft$TimeLeft_Exp, na.rm = TRUE)
sd(data.suicide.timeleft$TimeLeft_Exp, na.rm = TRUE)

t.test(data.suicide.timeleft$Std_Ctrl, data.suicide.timeleft$TimeLeft_Exp, paired = TRUE)
cohensD(data.suicide.timeleft$Std_Ctrl, data.suicide.timeleft$TimeLeft_Exp, method = "paired")

#Social Harm
mean(data.suicide.socharm$Std_Ctrl, na.rm = TRUE)
sd(data.suicide.socharm$Std_Ctrl, na.rm = TRUE)

mean(data.suicide.socharm$SocHarm_Exp, na.rm = TRUE)
sd(data.suicide.socharm$SocHarm_Exp, na.rm = TRUE)

t.test(data.suicide.socharm$Std_Ctrl, data.suicide.socharm$SocHarm_Exp, paired = TRUE)
cohensD(data.suicide.socharm$Std_Ctrl, data.suicide.socharm$SocHarm_Exp, method = "paired")

#Soul Taint
mean(data.suicide.soultaint$Std_Ctrl, na.rm = TRUE)
sd(data.suicide.soultaint$Std_Ctrl, na.rm = TRUE)

mean(data.suicide.soultaint$SoulTaint_Exp, na.rm = TRUE)
sd(data.suicide.soultaint$SoulTaint_Exp, na.rm = TRUE)

t.test(data.suicide.soultaint$Std_Ctrl, data.suicide.soultaint$SoulTaint_Exp, paired = TRUE)
cohensD(data.suicide.soultaint$Std_Ctrl, data.suicide.soultaint$SoulTaint_Exp, method = "paired")

#Self-Harm
mean(data.suicide.selfharm$SelfHarm_Ctrl, na.rm = TRUE)
sd(data.suicide.selfharm$SelfHarm_Ctrl, na.rm = TRUE)

mean(data.suicide.selfharm$Std_Ctrl, na.rm = TRUE)
sd(data.suicide.selfharm$Std_Ctrl, na.rm = TRUE)

t.test(data.suicide.selfharm$SelfHarm_Ctrl, data.suicide.selfharm$Std_Ctrl, paired = TRUE)
cohensD(data.suicide.selfharm$SelfHarm_Ctrl, data.suicide.selfharm$Std_Ctrl, method = "paired")

#Severity of Circumstances
mean(data.suicide.severity$Severity_Ctrl, na.rm = TRUE)
sd(data.suicide.severity$Severity_Ctrl, na.rm = TRUE)

mean(data.suicide.severity$Severity_Exp, na.rm = TRUE)
sd(data.suicide.severity$Severity_Exp, na.rm = TRUE)

t.test(data.suicide.severity$Severity_Ctrl, data.suicide.severity$Severity_Exp, paired = TRUE)
cohensD(data.suicide.severity$Severity_Ctrl, data.suicide.severity$Severity_Exp, method = "paired")

#Euthanasia
mean(data.suicide.euthanasia$Euth_Ctrl, na.rm = TRUE)
sd(data.suicide.euthanasia$Euth_Ctrl, na.rm = TRUE)

mean(data.suicide.euthanasia$Euth_Exp, na.rm = TRUE)
sd(data.suicide.euthanasia$Euth_Exp, na.rm = TRUE)

t.test(data.suicide.euthanasia$Euth_Ctrl, data.suicide.euthanasia$Euth_Exp, paired = TRUE)
cohensD(data.suicide.euthanasia$Euth_Ctrl, data.suicide.euthanasia$Euth_Exp, method = "paired")

#Exposure
mean(data.suicide.exposure$Std_Ctrl, na.rm = TRUE)
sd(data.suicide.exposure$Std_Ctrl, na.rm = TRUE)

mean(data.suicide.exposure$Exposure_Exp, na.rm = TRUE)
sd(data.suicide.exposure$Exposure_Exp, na.rm = TRUE)

t.test(data.suicide.exposure$Std_Ctrl, data.suicide.exposure$Exposure_Exp, paired = TRUE)
cohensD(data.suicide.exposure$Std_Ctrl, data.suicide.exposure$Exposure_Exp, method = "paired")

#Attempt
mean(data.suicide.attempt$Std_Ctrl, na.rm = TRUE)
sd(data.suicide.attempt$Std_Ctrl, na.rm = TRUE)

mean(data.suicide.attempt$Attempt_Exp, na.rm = TRUE)
sd(data.suicide.attempt$Attempt_Exp, na.rm = TRUE)

t.test(data.suicide.attempt$Std_Ctrl, data.suicide.attempt$Attempt_Exp, paired = TRUE)
cohensD(data.suicide.attempt$Std_Ctrl, data.suicide.attempt$Attempt_Exp, method = "paired")

#Impulsive/Deliberate
mean(data.suicide.impulse$Impulse_Ctrl, na.rm = TRUE)
sd(data.suicide.impulse$Impulse_Ctrl, na.rm = TRUE)

mean(data.suicide.impulse$Impulse_Exp, na.rm = TRUE)
sd(data.suicide.impulse$Impulse_Exp, na.rm = TRUE)

t.test(data.suicide.impulse$Impulse_Ctrl, data.suicide.impulse$Impulse_Exp, paired = TRUE)
cohensD(data.suicide.impulse$Impulse_Ctrl, data.suicide.impulse$Impulse_Exp, method = "paired")

#Religious Background
mean(data.suicide.relig$Relig_Ctrl, na.rm = TRUE)
sd(data.suicide.relig$Relig_Ctrl, na.rm = TRUE)

mean(data.suicide.relig$Relig_Exp, na.rm = TRUE)
sd(data.suicide.relig$Relig_Exp, na.rm = TRUE)

t.test(data.suicide.relig$Relig_Ctrl, data.suicide.relig$Relig_Exp, paired = TRUE)
cohensD(data.suicide.relig$Relig_Ctrl, data.suicide.relig$Relig_Exp, method = "paired")



##One-sample t-tests comparing condition means to scale midpoint

#Time Left
t.test(data.suicide.timeleft$Std_Ctrl, mu = 8)
t.test(data.suicide.timeleft$TimeLeft_Exp, mu = 8)

#Social Harm
t.test(data.suicide.socharm$Std_Ctrl, mu = 8)
t.test(data.suicide.socharm$SocHarm_Exp, mu = 8)

#Soul Taint
t.test(data.suicide.soultaint$Std_Ctrl, mu = 8)
t.test(data.suicide.soultaint$SoulTaint_Exp, mu = 8)

#Self-Harm
t.test(data.suicide.selfharm$SelfHarm_Ctrl, mu = 8)
t.test(data.suicide.selfharm$Std_Ctrl, mu = 8)

#Severity of Circumstances
t.test(data.suicide.severity$Severity_Ctrl, mu = 8)
t.test(data.suicide.severity$Severity_Exp, mu = 8)

#Euthanasia
t.test(data.suicide.euthanasia$Euth_Ctrl, mu = 8)
t.test(data.suicide.euthanasia$Euth_Exp, mu = 8)

#Exposure
t.test(data.suicide.exposure$Std_Ctrl, mu = 8)
t.test(data.suicide.exposure$Exposure_Exp, mu = 8)

#Attempt
t.test(data.suicide.attempt$Std_Ctrl, mu = 8)
t.test(data.suicide.attempt$Attempt_Exp, mu = 8)

#Impulsive/Deliberate
t.test(data.suicide.impulse$Impulse_Ctrl, mu = 8)
t.test(data.suicide.impulse$Impulse_Exp, mu = 8)

#Religious Background
t.test(data.suicide.relig$Relig_Ctrl, mu = 8)
t.test(data.suicide.relig$Relig_Exp, mu = 8)


